console.log("SuiteCRM custom badges script loaded");

document.addEventListener("DOMContentLoaded", function () {
    console.log("SuiteCRM custom badges applying...");

    const safeClassName = (value) => {
        return "tag-" + value
            .toLowerCase()
            .trim()
            .replace(/[%]+/g, "percent")   // turn "%" into "percent"
            .replace(/[^a-z0-9]+/g, "-")   // everything else → dash
            .replace(/^-+|-+$/g, "");      // trim leading/trailing dashes
    };

    const applyBadges = () => {
        document.querySelectorAll("scrm-dropdownenum-detail").forEach(el => {
            const value = el.textContent.trim();

            // Skip if already processed
            if (el.innerHTML.includes("badge-pill")) {
                return;
            }

            // Skip empty values
            if (!value || value === "" || value === " " || value === "&nbsp;") {
                el.style.display = "none";
                return;
            }

            // Create class
            const badgeClass = "badge-pill " + safeClassName(value);

            // Apply the badge styling
            el.innerHTML = `<span class="${badgeClass}">${value}</span>`;
        });
    };

    // Run once after page load
    applyBadges();

    // Re-run whenever DOM changes
    const observer = new MutationObserver((mutations) => {
        let shouldReapply = false;
        mutations.forEach((mutation) => {
            if (mutation.type === 'childList' && mutation.addedNodes.length > 0) {
                mutation.addedNodes.forEach((node) => {
                    if (node.nodeType === Node.ELEMENT_NODE) {
                        if (node.querySelector && node.querySelector('scrm-dropdownenum-detail')) {
                            shouldReapply = true;
                        }
                        if (node.tagName === 'SCRM-DROPDOWNENUM-DETAIL') {
                            shouldReapply = true;
                        }
                    }
                });
            }
        });
        
        if (shouldReapply) {
            setTimeout(applyBadges, 100);
        }
    });

    observer.observe(document.body, { 
        childList: true, 
        subtree: true 
    });

    window.addEventListener('resize', applyBadges);
    window.addEventListener('scroll', applyBadges);

    console.log("SuiteCRM custom badges applied successfully");
});
